<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted' => 'The :attribute field must be accepted.',
    'accepted_if' => 'The :attribute field must be accepted when :other is :value.',
    'active_url' => 'The :attribute field must be a valid URL.',
    'after' => 'The :attribute field must be a date after :date.',
    'after_or_equal' => 'The :attribute field must be a date after or equal to :date.',
    'alpha' => 'The :attribute field must only contain letters.',
    'alpha_dash' => 'The :attribute field must only contain letters, numbers, dashes, and underscores.',
    'alpha_num' => 'The :attribute field must only contain letters and numbers.',
    'array' => 'The :attribute field must be an array.',
    'ascii' => 'The :attribute field must only contain single-byte alphanumeric characters and symbols.',
    'before' => 'The :attribute field must be a date before :date.',
    'before_or_equal' => 'The :attribute field must be a date before or equal to :date.',
    'between' => [
        'array' => 'The :attribute field must have between :min and :max items.',
        'file' => 'The :attribute field must be between :min and :max kilobytes.',
        'numeric' => 'The :attribute field must be between :min and :max.',
        'string' => 'The :attribute field must be between :min and :max characters.',
    ],
    'boolean' => 'The :attribute field must be true or false.',
    'can' => 'The :attribute field contains an unauthorized value.',
    'confirmed' => 'The :attribute field confirmation does not match.',
    'contains' => 'The :attribute field is missing a required value.',
    'current_password' => 'The password is incorrect.',
    'date' => 'The :attribute field must be a valid date.',
    'date_equals' => 'The :attribute field must be a date equal to :date.',
    'date_format' => 'The :attribute field must match the format :format.',
    'decimal' => 'The :attribute field must have :decimal decimal places.',
    'declined' => 'The :attribute field must be declined.',
    'declined_if' => 'The :attribute field must be declined when :other is :value.',
    'different' => 'The :attribute field and :other must be different.',
    'digits' => 'The :attribute field must be :digits digits.',
    'digits_between' => 'The :attribute field must be between :min and :max digits.',
    'dimensions' => 'The :attribute field has invalid image dimensions.',
    'distinct' => 'The :attribute field has a duplicate value.',
    'doesnt_end_with' => 'The :attribute field must not end with one of the following: :values.',
    'doesnt_start_with' => 'The :attribute field must not start with one of the following: :values.',
    'email' => 'The :attribute field must be a valid email address.',
    'ends_with' => 'The :attribute field must end with one of the following: :values.',
    'enum' => 'The selected :attribute is invalid.',
    'exists' => 'The selected :attribute is invalid.',
    'extensions' => 'The :attribute field must have one of the following extensions: :values.',
    'file' => 'The :attribute field must be a file.',
    'filled' => 'The :attribute field must have a value.',
    'gt' => [
        'array' => 'The :attribute field must have more than :value items.',
        'file' => 'The :attribute field must be greater than :value kilobytes.',
        'numeric' => 'The :attribute field must be greater than :value.',
        'string' => 'The :attribute field must be greater than :value characters.',
    ],
    'gte' => [
        'array' => 'The :attribute field must have :value items or more.',
        'file' => 'The :attribute field must be greater than or equal to :value kilobytes.',
        'numeric' => 'The :attribute field must be greater than or equal to :value.',
        'string' => 'The :attribute field must be greater than or equal to :value characters.',
    ],
    'hex_color' => 'The :attribute field must be a valid hexadecimal color.',
    'image' => 'The :attribute field must be an image.',
    'in' => 'The selected :attribute is invalid.',
    'in_array' => 'The :attribute field must exist in :other.',
    'integer' => 'The :attribute field must be an integer.',
    'ip' => 'The :attribute field must be a valid IP address.',
    'ipv4' => 'The :attribute field must be a valid IPv4 address.',
    'ipv6' => 'The :attribute field must be a valid IPv6 address.',
    'json' => 'The :attribute field must be a valid JSON string.',
    'list' => 'The :attribute field must be a list.',
    'lowercase' => 'The :attribute field must be lowercase.',
    'lt' => [
        'array' => 'The :attribute field must have less than :value items.',
        'file' => 'The :attribute field must be less than :value kilobytes.',
        'numeric' => 'The :attribute field must be less than :value.',
        'string' => 'The :attribute field must be less than :value characters.',
    ],
    'lte' => [
        'array' => 'The :attribute field must not have more than :value items.',
        'file' => 'The :attribute field must be less than or equal to :value kilobytes.',
        'numeric' => 'The :attribute field must be less than or equal to :value.',
        'string' => 'The :attribute field must be less than or equal to :value characters.',
    ],
    'mac_address' => 'The :attribute field must be a valid MAC address.',
    'max' => [
        'array' => 'The :attribute field must not have more than :max items.',
        'file' => 'The :attribute field must not be greater than :max kilobytes.',
        'numeric' => 'The :attribute field must not be greater than :max.',
        'string' => 'The :attribute field must not be greater than :max characters.',
    ],
    'max_digits' => 'The :attribute field must not have more than :max digits.',
    'mimes' => 'The :attribute field must be a file of type: :values.',
    'mimetypes' => 'The :attribute field must be a file of type: :values.',
    'min' => [
        'array' => 'The :attribute field must have at least :min items.',
        'file' => 'The :attribute field must be at least :min kilobytes.',
        'numeric' => 'The :attribute field must be at least :min.',
        'string' => 'The :attribute field must be at least :min characters.',
    ],
    'min_digits' => 'The :attribute field must have at least :min digits.',
    'missing' => 'The :attribute field must be missing.',
    'missing_if' => 'The :attribute field must be missing when :other is :value.',
    'missing_unless' => 'The :attribute field must be missing unless :other is :value.',
    'missing_with' => 'The :attribute field must be missing when :values is present.',
    'missing_with_all' => 'The :attribute field must be missing when :values are present.',
    'multiple_of' => 'The :attribute field must be a multiple of :value.',
    'not_in' => 'The selected :attribute is invalid.',
    'not_regex' => 'The :attribute field format is invalid.',
    'numeric' => 'The :attribute field must be a number.',
    'password' => [
        'letters' => 'The :attribute field must contain at least one letter.',
        'mixed' => 'The :attribute field must contain at least one uppercase and one lowercase letter.',
        'numbers' => 'The :attribute field must contain at least one number.',
        'symbols' => 'The :attribute field must contain at least one symbol.',
        'uncompromised' => 'The given :attribute has appeared in a data leak. Please choose a different :attribute.',
    ],
    'present' => 'The :attribute field must be present.',
    'present_if' => 'The :attribute field must be present when :other is :value.',
    'present_unless' => 'The :attribute field must be present unless :other is :value.',
    'present_with' => 'The :attribute field must be present when :values is present.',
    'present_with_all' => 'The :attribute field must be present when :values are present.',
    'prohibited' => 'The :attribute field is prohibited.',
    'prohibited_if' => 'The :attribute field is prohibited when :other is :value.',
    'prohibited_unless' => 'The :attribute field is prohibited unless :other is in :values.',
    'prohibits' => 'The :attribute field prohibits :other from being present.',
    'regex' => 'The :attribute field format is invalid.',
    'required' => 'The :attribute field is required.',
    'required_array_keys' => 'The :attribute field must contain entries for: :values.',
    'required_if' => 'The :attribute field is required when :other is :value.',
    'required_if_accepted' => 'The :attribute field is required when :other is accepted.',
    'required_if_declined' => 'The :attribute field is required when :other is declined.',
    'required_unless' => 'The :attribute field is required unless :other is in :values.',
    'required_with' => 'The :attribute field is required when :values is present.',
    'required_with_all' => 'The :attribute field is required when :values are present.',
    'required_without' => 'The :attribute field is required when :values is not present.',
    'required_without_all' => 'The :attribute field is required when none of :values are present.',
    'same' => 'The :attribute field must match :other.',
    'size' => [
        'array' => 'The :attribute field must contain :size items.',
        'file' => 'The :attribute field must be :size kilobytes.',
        'numeric' => 'The :attribute field must be :size.',
        'string' => 'The :attribute field must be :size characters.',
    ],
    'starts_with' => 'The :attribute field must start with one of the following: :values.',
    'string' => 'The :attribute field must be a string.',
    'timezone' => 'The :attribute field must be a valid timezone.',
    'unique' => 'The :attribute has already been taken.',
    'uploaded' => 'The :attribute failed to upload.',
    'uppercase' => 'The :attribute field must be uppercase.',
    'url' => 'The :attribute field must be a valid URL.',
    'ulid' => 'The :attribute field must be a valid ULID.',
    'uuid' => 'The :attribute field must be a valid UUID.',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'users' => [
            'invalid' => 'The :attribute value is invalid.',
            'format' => 'The {$attribute} value is not correctly formated.',
        ],
        'prohibited_without' => 'The :attribute field is prohibited when :values is not present.',
        'mobile_number' => 'The :attribute is invalid.',
        'coupon' => 'The :attribute is invalid.',
        'recaptcha' => 'Captcha verification failed! Please try again.',
        'delay' => [
            'invalid' => 'The :attribute is invalid.',
            'range' => 'The :attribute must be between 0 and 120.',
        ],
        'exists_and_authorized' => 'The selected :attribute is invalid.|The selected :attribute are invalid.',
        'contact_list_not_empty' => 'The :attribute has no active subscribers!',
        'mms_attachment_url' => [
            'invalid' => 'The :attribute is invalid.',
            'file_type' => 'The :attribute does not point to an allowed file type.',
        ],
        'spreadsheet' => 'The :attribute is not a valid spreadsheet file or does not contain the required data.',
        'update_file' => 'The update file is invalid.',
        'blacklist' => 'The mobile number is blacklisted.',
        'require_with_but_without' => 'The :attribute field is required when :with is present and :without is absent.',
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap our attribute placeholder
    | with something more reader friendly such as "E-Mail Address" instead
    | of "email". This simply helps us make our message more expressive.
    |
    */

    'attributes' => [
        'file' => 'File',
        'name' => 'Name',
        'email' => 'Email Address',
        'messages.*' => 'Message #:position',
        'response' => 'Response',
        'type' => 'Type',
        'attachments' => 'Attachments',
        'attachments.*' => 'Attachment #:position',
        'criterion' => 'Condition',
        'enabled' => 'Enabled',
        'mobile_number' => 'Mobile Number',
        'subscribed' => 'Subscribed',
        'code' => 'Code',
        'discount' => 'Discount',
        'quantity' => 'Quantity',
        'expires_at' => 'Expires At',
        'label' => 'Label',
        'tag' => 'Tag',
        'options.*.label' => 'Option #:position label',
        'options.*.value' => 'Option #:position value',
        'default_value' => 'Default Value',
        'default_value.*' => 'Default Value #:position',
        'required' => 'Required',
        'description' => 'Description',
        'price' => 'Price',
        'interval' => 'Interval',
        'interval_unit' => 'Interval Unit',
        'currency' => 'Currency',
        'features.credits' => 'Credits',
        'features.contacts' => 'Contacts',
        'features.contact_lists' => 'Contact Lists',
        'features.devices' => 'Devices',
        'features.sending_servers' => 'Sending Servers',
        'features.sender_ids' => 'Sender IDs',
        'features.templates' => 'Templates',
        'features.webhooks' => 'Webhooks',
        'features.api_tokens' => 'API Tokens',
        'features.data_export' => 'Data Export',
        'driver' => 'Driver',
        'supported_types.*' => 'Supported Type #:position',
        'rate' => 'Rate',
        'country' => 'Country',
        'inclusive' => 'Inclusive',
        'content' => 'Content',
        'url' => 'URL',
        'secret' => 'Secret',
        'events.*' => 'Event #:position',
        'sims' => 'Sims',
        'sims.*' => 'Sim #:position',
        'sender_ids' => 'Sender IDs',
        'sender_ids.*' => 'Sender ID #:position',
        'recipients' => 'Recipients',
        'mobile_numbers' => 'Mobile Numbers',
        'mobile_numbers.*' => 'Mobile Number #:position',
        'spreadsheet' => 'Spreadsheet',
        'contact_lists' => 'Contact Lists',
        'contact_lists.*' => 'Contact List #:position',
        'message' => 'Message',
        'delivery_report' => 'Delivery Report',
        'delay' => 'Delay',
        'prioritize' => 'Prioritize',
        'scheduled_at' => 'Schedule At',
        'ussd_codes.*' => 'USSD Code #:position',
        'users' => 'Users',
        'timezone' => 'Timezone',
        'recurring' => 'Recurring',
        'frequency' => 'Frequency',
        'frequency_unit' => 'Frequency Unit',
        'ends_at' => 'Ends At',
        'days_of_week' => 'Days of Week',
        'days_of_week.*' => 'Days of Week #:position',
        'active_hours' => 'Active Hours',
        'active_hours.start' => 'Active Hours start',
        'active_hours.end' => 'Active Hours end',
        'value' => 'Value',
        'first_name' => 'First Name',
        'last_name' => 'Last Name',
        'company' => 'Company',
        'city' => 'City',
        'address_line_1' => 'Address Line 1',
        'address_line_2' => 'Address Line 2',
        'state' => 'State',
        'postal_code' => 'Postal Code',
        'phone' => 'phone',
        'payment_method' => 'Payment Method',
        'coupon' => 'Coupon',
        'guest' => 'Guest',
        'member' => 'Member',
        'billing_info' => 'Billing Information',
        'recaptcha.site_key' => 'reCAPTCHA Site Key',
        'recaptcha.secret_key' => 'reCAPTCHA Secret Key',
        'logo' => 'Logo',
        'app' => 'Android Application',
        'mailer' => 'Mailer',
        'sendmail.path' => 'Sendmail Path',
        'smtp.host' => 'Host',
        'smtp.port' => 'Port',
        'smtp.encryption' => 'Encryption',
        'smtp.username' => 'Username',
        'smtp.password' => 'Password',
        'mailgun.domain' => 'Domain',
        'mailgun.secret' => 'Secret',
        'mailgun.endpoint' => 'Endpoint',
        'ses.key' => 'Key',
        'ses.secret' => 'Secret',
        'ses.region' => 'Region',
        'postmark.token' => 'Token',
        'reset_at' => 'Reset At',
        'update' => 'Update',
        'device.model' => 'Model',
        'device.battery' => 'Battery',
        'device.is_charging' => 'Is Charging',
        'device.android_version' => 'Android Version',
        'device.sdk_version' => 'SDK Version',
        'device.app_version' => 'App Version',
        'device.app_version_code' => 'App Version Code',
        'device.sims.*.name' => 'Name',
        'device.sims.*.number' => 'Mobile Number',
        'device.sims.*.carrier' => 'Carrier',
        'device.sims.*.country' => 'Country',
        'device.sims.*.icc_id' => 'ICCID',
        'device.sims.*.mcc' => 'Mobile Country Code',
        'device.sims.*.mnc' => 'Mobile Network Code',
        'device.sims.*.data_roaming' => 'Data Roaming',
        'device.sims.*.signal_strength' => 'Signal Strength',
        'device.sims.*.slot' => 'Slot',
        'device.sims.*.active'  => 'Active',
        'sim' => 'Sim',
        'sender_id' => 'Sender ID',
    ],

];
