<?php

declare(strict_types=1);

namespace OpenSpout\Common\Entity\Cell;

use DateTimeInterface;
use OpenSpout\Common\Entity\Cell;
use OpenSpout\Common\Entity\Comment\Comment;
use OpenSpout\Common\Entity\Style\Style;

final readonly class DateTimeCell extends Cell
{
    private DateTimeInterface $value;

    public function __construct(
        DateTimeInterface $value,
        ?Style $style = null,
        ?Comment $comment = null,
    ) {
        parent::__construct($style, $comment);
        $this->value = $value;
    }

    public function getValue(): DateTimeInterface
    {
        return $this->value;
    }

    public function withValue(DateTimeInterface $value): self
    {
        return new self($value, $this->style, $this->comment);
    }

    public function withStyle(Style $style): self
    {
        return new self($this->value, $style, $this->comment);
    }

    public function withoutStyle(): self
    {
        return new self($this->value, null, $this->comment);
    }

    public function withComment(Comment $comment): self
    {
        return new self($this->value, $this->style, $comment);
    }

    public function withoutComment(): self
    {
        return new self($this->value, $this->style, null);
    }
}
